#!/usr/bin/perl
#
# Distributed.Net Personal Proxy Log Compressor v1.0.4
# Written by Brad Mertz - bphantom@xmission.com
# Member of: Team AnandTech RC5/OGR
#
# Some code borrowed from PPStats which was written by Kevin Pesce -
# http://sourceforge.net/projects/ppstats/
#
# Copyright : (C) Brad Mertz 2000
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2,
# June 1991.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details:
# 
# http://www.fsf.org/copyleft/gpl.html
#

($appdir) = split(m|([^/]+)$|, $0, 2);
$appini = $appdir . "logcomp.ini"; 

# You shouldn't need to edit anything below this line, unless you want to
# clean up some of my amateur perl coding.  Please send your modifications
# to me, so I may learn the correct ways.  :-)  -Brad

print "\nDistributed.Net Personal Proxy Log Compressor  -  v1.0.4\n";
print "Coded by: Brad Mertz  (c) 2000\n\n";

if ($ARGV[0] eq "-h" or $ARGV[0] eq "--h" or $ARGV[0] eq "-help" or $ARGV[0] eq "--help" or $ARGV[0] eq "help") {
   print "Usage: logcomp options\n\n";
   print "options --\n\n";
   print "    -dumpdate=CCYYMMDD - (e.g. 2000092*) Dumps all logfiles matching this\n";
   print "                         wildcard into a single log file.  -dumplog must\n";
   print "                         be specified for this to work.\n\n";
   print "    -dumplog=FILENAME  - Log filename for the dumpdate command.\n";
   print "                         NOTE: The contest type (RC5 or OGR) will be\n";
   print "                         appended onto the end of the filename.\n\n";
   print "    -multilog=CCYYMMDD - (e.g. 200010**) Useful for compressing a large\n";
   print "                         range of dates.\n\n";
   print "    -offset=NUM        - Default is -1.  NOTE: Offset corresponds to UTC time.\n\n";
   print "    -rewind=NUMOFDAYS  - Default is 1 (same day).  Starts from offset and\n";
   print "                         compresses however many days you want to go back\n";
   print "                         Useful for recently missed log files.\n\n\n";
   exit;
}

# Default values - Only change the values in the logcomp.ini file.
$logprefs{offset} = -1;
$logprefs{rewind} = 0;
$logprefs{logreplace} = "false";

open(INIFILE, $appini) or die "Unable to open initialization file [$appini].\n\n";
   while (defined($entry = <INIFILE>)) {
        chomp($entry);               # no newline
        $entry =~ s/#.*//;           # no comments
        $entry =~ s/^\s+//;          # no leading white
        $entry =~ s/\s+$//;          # no trailing white
        
        next unless length($entry);  # anything left?
        ($var, $value) = split(/\s*=\s*/, $entry, 2);
        $value =~ s/\"//g;           # remove "'s
        $value =~ tr/A-Z/a-z/;       # convert to lowercase
        $var =~ tr/A-Z/a-z/;         # convert to lowercase
        $logprefs{$var} = $value     # set var to value
    }
close INIFILE;

my $i = 0; while (length($ARGV[$i]) >1) {
   chomp($ARGV[$i]);            # no newline
   $ARGV[$i] =~ s/\-//;
   $ARGV[$i] =~ s/^\s+//;          # no leading white
   $ARGV[$i] =~ s/\s+$//;          # no trailing white
   ($var, $value) = split(/\s*=\s*/, $ARGV[$i], 2);
   $value =~ s/\"//g;           # remove "'s
   $value =~ tr/A-Z/a-z/;       # convert to lowercase
   $var =~ tr/A-Z/a-z/;         # convert to lowercase
   $logprefs{$var} = $value;     # set var to value
   $i++;
}

if (!length($logprefs{pproxyini})) { print "The pproxyini string is empty.\n\n"; exit; }
if ($logprefs{logbackup} eq "true" && !length($logprefs{backupdir})) { print "Logbackup is true, but no backup directory is defined.\n\n"; exit; }

use File::Copy;
use Time::Local;

# Open up pproxy configuration file and find out where the key log files are stored.
open(LOGFILE, $logprefs{pproxyini});
$i=0; while (defined($entry = <LOGFILE>)) {
   if ($entry=~/logfilekeyblock=/) {
      $entry =~ s/\\/\//g;  # Gotta love the Big W :-)
      $entry = substr($entry,16,-1);

      if (substr($entry,1,1) eq ":" or substr($entry,0,1) eq "/") { @contests[$i] = $entry; }
      else { @contests[$i] = substr($logprefs{pproxyini}, 0, rindex($logprefs{pproxyini},"/")+1) . $entry; } $i++; next;
   } 
} close LOGFILE;

# Determine if compressor is command line run
if (length($logprefs{dumpdate}) eq 8 && length($logprefs{dumplog})>0) {
   $procdate = $logprefs{dumpdate};
   $logprefs{logreplace} = "false";
   $special = "*";
   unlink <$logprefs{dumplog}.*>;
} elsif (length($logprefs{multilog}) eq 8) { 
   $procdate = $logprefs{multilog}; 
   $special = "*";
} else { 
   $procdate = "????????";
}

if ($logprefs{offset} > 0) { $logprefs{offset} = 0;}
if ($logprefs{rewind} > 0) { $logprefs{rewind} =~ s/\+//; $logprefs{rewind} = ("-" . $logprefs{rewind}); }
if ($logprefs{rewind} eq 0) { $logprefs{rewind} = -1; }
$logprefs{rewind}++;

for $i (0 .. $#contests) {
   @logfiles = <@contests[$i]$procdate.log>;
   @logfiles = reverse sort @logfiles;

   ($year, $month, $mday) = &nice_gmtime(time+($logprefs{offset}*86400));
   $startdate = "$year$month$mday";
   ($year, $month, $mday) = &nice_gmtime(time+(($logprefs{offset}*86400) + ($logprefs{rewind}*86400)));
   $finishdate = "$year$month$mday";

   foreach $ulogfile (@logfiles) {  
      next if (!-e ($ulogfile));

      if ($special eq "*" or (substr($ulogfile,length($ulogfile)-12,8)<=$startdate && substr($ulogfile,length($ulogfile)-12,8)>=$finishdate)) { 
         $logdir = substr($ulogfile,0,rindex($ulogfile,"/")+1);
         $conprefix = substr($ulogfile,rindex($ulogfile,"/")+1,-12);
         $logdate = substr($ulogfile,length($ulogfile)-12,8);

         open(LOGFILE, $ulogfile);
         print "Processing log       [$ulogfile]\n";

         undef %full;
         undef %final;

         while (defined($entry = <LOGFILE>)) {
            # Trim off the fat and convert to lowercase
            chomp($entry);
            $entry =~ tr/A-Z/a-z/;

            # Format of the log file: "Date/Time HostIP, Email, Block, Block Size, OS, CPU, Client Version"
            ($datetime, $ipaddr, $email, $block, $nkeys, $os, $cpu, $ver, $space) = split(/,/, $entry);
            $main="$email,$ipaddr,$os,$cpu,$ver"; 

            if (defined($full{$main})) {
               $full{$main} += "$nkeys";
               $full{$main}{$main} = "$datetime,$block";
            } else { 
               $full{$main} = "$nkeys";
               $full{$main}{$main} = "$datetime,$block";
            }

            if (substr($block,2,1) eq "/") { 
               @contesttype[$i] = "ogr";
               $ogrtotal+=$nkeys;
               $ogrtotallines+=1;
            } else { 
               @contesttype[$i] = "rc5";
               $rc5total+=$nkeys;
               $rc5totallines+=1;
            }
         }

         close LOGFILE;

         if (defined(%full)) {
            foreach $main (keys %full) {   
               ($email, $ipaddr, $os, $cpu, $ver, $space) = split(/,/, $main);
               ($datetime, $block) = split(/,/, $full{$main}{$main});
               $final{"$datetime,$ipaddr,$email,$block,$full{$main},$os,$cpu,$ver"} = 0;
            }

            if ($logprefs{logreplace} =~ "true") {
               if ($logprefs{logbackup} =~ "true") {
                  print "Backing up log file  [$logprefs{backupdir}$conprefix$logdate.log]\n";
                  move("$logdir$conprefix$logdate.log", ("$logprefs{backupdir}$conprefix$logdate.log"));
               }
               $outputfile = "$logdir$conprefix$logdate.log";
            } else { $outputfile = "$logdir$conprefix$logdate.cmp"; }

            if ($special eq "*" && defined($logprefs{dumplog})) {
               $outputfile = "$logprefs{dumplog}". "." ."@contesttype[$i]";
               if (!-e $outputfile) { open(OUTFILE, "> " . $outputfile);
               } else { open(OUTFILE, ">> " . $outputfile); }
               foreach $main (sort (keys %final)) { print OUTFILE "$main\n"; }     
               print "Exporting compressed [$outputfile]\n\n";
            } else {
               open(OUTFILE, "> " . $outputfile);
               foreach $main (sort (keys %final)) { print OUTFILE "$main\n"; }     
               print "Exporting compressed [$outputfile]\n\n";
            }
            close OUTFILE;

         } else { print "\nCould not open log file [$ulogfile]\n" . "Aborting . . .\n\n"; exit; } 
      }
   }
}

if (defined($rc5total)) { 
   print "RC5 - Total Lines: $rc5totallines\n";
   print "RC5 - Total 2^28 Blocks: $rc5total\n\n";
}

if (defined($ogrtotal)) { 
   print "OGR - Total Lines: $ogrtotallines\n";
   print "OGR - Total Nodes: $ogrtotal\n\n";
}


sub nice_gmtime {
    my @gmt = gmtime shift @_;
    my $i;

    $gmt[4]++;
    $gmt[5] += 1900;

    
    for ($i = 1; $i < 5; $i++) {
        while (length($gmt[$i]) < 2) {
            $gmt[$i] = "0" . $gmt[$i];
        }
    }
    return ($gmt[5], $gmt[4], $gmt[3]);
}  # nice_gmtime


